/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj.asistente.fideicomiso.valores;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.ModeloValores;
import ec.gob.sri.dimm.data.impl.DataCatalogos;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class ModeloValoresBeneficiario
implements ModeloValores {
    private boolean inicializado;
    private DataCatalogos dc = new DataCatalogos();
    private static Map<String, ElementoNombreValor<String>> paises = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposPago = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposIdentificacion = new LinkedHashMap<String, ElementoNombreValor<String>>();
    private final Map<String, ElementoNombreValor<String>> tiposDeBeneficiarios = new LinkedHashMap<String, ElementoNombreValor<String>>();

    public void inicializar() {
        if (!this.inicializado) {
            this.cargarPaises();
            this.cargarPagos();
            this.cargarTiposIdentifacion();
            this.cargarTiposDeBeneficiario();
            this.inicializado = true;
        }
    }

    private void cargarTiposIdentifacion() {
        this.tiposIdentificacion.clear();
        this.tiposIdentificacion.put("R", (ElementoNombreValor<String>)new ElementoNombreValor("RUC", (Object)"R"));
        this.tiposIdentificacion.put("C", (ElementoNombreValor<String>)new ElementoNombreValor("CEDULA", (Object)"C"));
        this.tiposIdentificacion.put("P", (ElementoNombreValor<String>)new ElementoNombreValor("PASAPORTE/IDENTIFICACION TRIBUTARIA DEL EXTERIOR", (Object)"P"));
    }

    private void cargarTiposDeBeneficiario() {
        this.tiposDeBeneficiarios.clear();
        Map tiposConsultados = UtilCatalogosATS.crearInstancia().obtenerTiposDeContribuyente();
        for (Map.Entry tipoContribuyente : tiposConsultados.entrySet()) {
            this.tiposDeBeneficiarios.put((String)tipoContribuyente.getKey(), (ElementoNombreValor<String>)new ElementoNombreValor((String)tipoContribuyente.getValue(), (Object)((String)tipoContribuyente.getKey())));
        }
    }

    private void cargarPagos() {
        this.tiposPago.clear();
        this.tiposPago.put("01", (ElementoNombreValor<String>)new ElementoNombreValor("PAGO A RESIDENTE / ESTABLECIMIENTO PERMANENTE", (Object)"01"));
        this.tiposPago.put("02", (ElementoNombreValor<String>)new ElementoNombreValor("PAGO A NO RESIDENTE", (Object)"02"));
    }

    public BigDecimal cargarPorcentajeFideicomiso(String codigoFideicomiso) {
        BigDecimal porcentaje = UtilCatalogosATS.crearInstancia().obtenerPorcentajeFideicomiso(codigoFideicomiso);
        porcentaje = porcentaje.setScale(2, 6);
        return porcentaje;
    }

    public List<ElementoNombreValor<String>> getPaises() {
        return new ArrayList<ElementoNombreValor<String>>(paises.values());
    }

    private void cargarPaises() {
        paises.clear();
        TreeSet<ElementoNombreValor<String>> oPaises = new TreeSet<ElementoNombreValor<String>>(this.getComparadorElementoNombreValor());
        Map cPaises = this.dc.obtenerPaises();
        for (Map.Entry entry : cPaises.entrySet()) {
            if ("593".equals(entry.getKey())) continue;
            oPaises.add((ElementoNombreValor<String>)new ElementoNombreValor((String)entry.getValue(), (Object)((String)entry.getKey())));
        }
        for (ElementoNombreValor elementoNombreValor : oPaises) {
            paises.put((String)elementoNombreValor.getValor(), (ElementoNombreValor<String>)elementoNombreValor);
        }
    }

    public List<ElementoNombreValor<String>> getTiposPagos() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposPago.values());
    }

    public List<ElementoNombreValor<String>> getTiposIdentificacion() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposIdentificacion.values());
    }

    public ElementoNombreValor<String> obtenerTipoIdentificacion(String tipoIdentificacion) {
        return StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? null : this.tiposIdentificacion.get(tipoIdentificacion);
    }

    public ElementoNombreValor<String> obtenerTipoPago(String tipoPago) {
        return StringUtil.isNullOrEmpty((String)tipoPago) ? null : this.tiposPago.get(tipoPago);
    }

    private Comparator<ElementoNombreValor<String>> getComparadorElementoNombreValor() {
        return new Comparator<ElementoNombreValor<String>>(){

            @Override
            public int compare(ElementoNombreValor<String> e1, ElementoNombreValor<String> e2) {
                return e1.getEtiqueta().compareTo(e2.getEtiqueta());
            }
        };
    }

    public ElementoNombreValor<String> obtenerPais(String pais) {
        return StringUtil.isNullOrEmpty((String)pais) ? null : paises.get(pais);
    }

    public List<ElementoNombreValor<String>> getTiposDeBeneficiarios() {
        return new ArrayList<ElementoNombreValor<String>>(this.tiposDeBeneficiarios.values());
    }

    public ElementoNombreValor<String> obtenerTipoDeBeneficiario(String codigoBeneficiario) {
        return StringUtil.isNullOrEmpty((String)codigoBeneficiario) ? null : this.tiposDeBeneficiarios.get(codigoBeneficiario);
    }
}

